/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class Slot {
    private static Logger log = Logger.getLogger(Slot.class);
    long idSlot;
    private CK_SLOT_INFO info;

    public Slot(PKCS11 pKCS11, long l) throws ExceptionObjet {
        this.idSlot = l;
        this.chargeInfo(pKCS11);
    }

    public void chargeInfo(PKCS11 pKCS11) throws ExceptionObjet {
        if (pKCS11 != null) {
            try {
                this.info = pKCS11.C_GetSlotInfo(this.idSlot);
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("Une erreur est survenue lors de la recuperation des informations du slot : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                throw new ExceptionObjet(201, "Une erreur est survenue lors de la r\u00e9cuperation des informations du slot");
            }
        } else {
            log.error((Object)"La librairie est nulle");
            throw new ExceptionObjet(201, "La librairie est nulle");
        }
    }

    public String getDescription() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.slotDescription);
        }
        log.error((Object)"Les informations de la session sont nulles, la description du slot est indisponible");
        throw new ExceptionObjet(201, "La description du slot est indisponible");
    }

    public String getFabricant() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.manufacturerID);
        }
        log.error((Object)"Les informations de la session sont nulles, l'identifiant du fabricant du slot est indisponible");
        throw new ExceptionObjet(201, "L'identifiant du fabricant du slot est indisponible");
    }

    public boolean isCarte() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 1L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur le slot est indisponible");
        throw new ExceptionObjet(201, "L'information sur le slot est indisponible");
    }

    public boolean isAmovible() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 2L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur le slot est indisponible");
        throw new ExceptionObjet(201, "L'information sur le slot est indisponible");
    }

    public boolean isMateriel() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 4L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur le slot est indisponible");
        throw new ExceptionObjet(201, "L'information sur le slot est indisponible");
    }

    public String getVersionMaterielle() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.hardwareVersion.toString();
        }
        log.error((Object)"Les informations de la session sont nulles, la version mat\u00e9rielle du slot est indisponible");
        throw new ExceptionObjet(201, "La version mat\u00e9rielle du slot est indisponible");
    }

    public String getVersionFirmware() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.firmwareVersion.toString();
        }
        log.error((Object)"Les informations de la session sont nulles, la version firmware du slot est indisponible");
        throw new ExceptionObjet(201, "La version firmware du slot est indisponible");
    }

    public String getLibelle() {
        if (this.info != null) {
            return "Slot " + Long.toString(this.idSlot) + " : " + new String(this.info.slotDescription).trim();
        }
        return "Slot " + Long.toString(this.idSlot);
    }

    public long getIdSlot() {
        return this.idSlot;
    }

    public String toString() {
        return this.getLibelle();
    }
}

